<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package z-build
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
  <div class="header-contact">
    <div class="container text-right">
      <a class="header-call" href="tel:0402 884 714">0402 884 714</a>|<a class="header-email"
        href="mailto:info@zdesign.com.au">info@zdesign.com.au</a>
    </div>
  </div>
  <header class="site-header">
    <nav class="navbar navbar-expand-lg navbar-light site-header-background">
      <div class="container">
        <a class="navbar-brand" href="<?php echo site_url(); ?>">
          <img src="<?php echo IMAGES_PATH; ?>/logo.png" alt="Logo">
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
          aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
           <?php
                $defaults = array(
                'theme_location'  => 'header menu',
                'menu'            => '2',
                'container'       => '',
                'container_class' => '',
                'container_id'    => '',
                'menu_class'      => 'navbar-nav ml-auto',
                'menu_id'         => '',
                'echo'            => true,
                'fallback_cb'     => 'wp_page_menu',
                'before'          => '',
                'after'           => '',
                'link_before'     => '',
                'link_after'      => '',
                'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                'depth'           => 0,
                'walker'          => new bootstrap_navwalker()
                );
                wp_nav_menu($defaults);
             ?>
        </div>
      </div>
    </nav>
  </header>
<?php if(is_front_page()){ ?>
  <section class="banner">
    <div class="bd-example">
      <div id="carouselExampleCaptions" class="carousel slide" data-ride="carousel">
        <ol class="carousel-indicators">
            <?php 
                $i=1;
                $args_slider_lists = array( 'post_type' => array('slider_list'), 'order_by' => 'id', 'order' => 'ASC', 'posts_per_page'   => -1 );
                      $posts_slider_lists =  get_posts( $args_slider_lists );
        
                foreach( $posts_slider_lists as $myslider_lists)                      
                { 
        
                ?>
                        <li data-target="#carouselExampleCaptions" data-slide-to="<?php echo $i ?>" class="<?php if($i==1){ echo "active"; } ?>"></li>
                <?php $i++; } ?>
        </ol>
        <div class="carousel-inner">
             <?php 
                $j=1;
                $args_slider_lists = array( 'post_type' => array('slider_list'), 'order_by' => 'id', 'order' => 'ASC', 'posts_per_page'   => -1 );
                      $posts_slider_lists =  get_posts( $args_slider_lists );
        
                foreach( $posts_slider_lists as $myslider_lists)                      
                { 
        
                    $feat_image_slider_list = wp_get_attachment_url( get_post_thumbnail_id($myslider_lists->ID) ); 
                ?>
            
                    <div class="carousel-item <?php if($j==1){ echo "active"; } ?>">
                        <img src="<?php echo $feat_image_slider_list; ?>" class="d-block w-100" alt="...">
                        <div class="carousel-caption">
                          <?php  echo get_post_field('post_content',$myslider_lists->ID); ?>
                          <a href="<?php echo get_the_permalink(31) ?>">View Projects</a>
                        </div>
                      </div>
                 <?php $j++; } ?>
        </div>
      </div>
    </div>
  </section>
  <?php }elseif(is_home()){ ?>

  <section class="section breadcrumb-wrapper">
        <div class="shell">
            <h2>Blog</h2>
        </div>
    </section>
<?php }else{ ?>

  <section class="section breadcrumb-wrapper">
        <div class="shell">
            <h2><?php the_title(); ?></h2>
        </div>
    </section>
<?php } ?>