<?php 
/** @post_type service **/
function vtd_wp_custom_post_type_service() {
	$labels = array(
		'name'               => _x( 'Services', 'post type general name' ),
		'singular_name'      => _x( 'Service', 'post type singular name' ),
		'add_new'            => _x( 'Add Service', 'Description' ),
		'add_new_item'       => __( 'Add New Service' ),
		'edit_item'          => __( 'Edit Service' ),
		'new_item'           => __( 'New Service' ),
		'all_items'          => __( 'All Services' ),
		'view_item'          => __( 'View Services' ),
		'search_items'       => __( 'Search Services' ),
		'not_found'          => __( 'No Service found' ),
		'not_found_in_trash' => __( 'No Service found in the Trash' ), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Services'
	);
	$args = array(
		'labels'        		=> $labels,
		'description'   		=> 'Services',
		'exclude_from_search' 	=> false,
		'public'        		=> true,
		'show_ui'        		=> true,
		'capability_type'  		=> 'post',
		'map_meta_cap'          => true,
		'publicly_queryable'    => true,
		'menu_icon'				=> 'dashicons-nametag',
		'menu_position' 		=> 7,
		'supports'      		=> array( 'title', 'page-attributes','editor', 'thumbnail' ),
		'has_archive'   		=> true,
		'show_in_nav_menus'		=> true,
		'hierarchical'          => true,
		'rewrite'               => true,
		'query_var'             => true
	);  
	register_post_type( 'service', $args );	
}
add_action( 'init', 'vtd_wp_custom_post_type_service' );


