<?php
/**
 * z-build functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package z-build
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

define('CSS_PATH', get_template_directory_uri() . '/assets/css');
define('js_path', get_template_directory_uri() . '/assets/js');
define('IMAGES_PATH', get_template_directory_uri() . '/assets/images');

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function z_build_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on z-build, use a find and replace
		* to change 'z-build' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'z-build', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'z-build' ),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'z_build_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'z_build_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function z_build_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'z_build_content_width', 640 );
}
add_action( 'after_setup_theme', 'z_build_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function z_build_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'z-build' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'z-build' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'z_build_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function z_build_scripts() {
	wp_enqueue_style( 'z-build-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'z-build-style', 'rtl', 'replace' );
	
	
	wp_enqueue_style( 'vout-bootstrap', CSS_PATH . '/bootstrap.min.css' );
	wp_enqueue_style( 'vout-font-settings', CSS_PATH . '/settings.css' );
  	wp_enqueue_style( 'vout-prettyPhoto', CSS_PATH . '/prettyPhoto.css' );
  	wp_enqueue_style( 'vout-animate', CSS_PATH . '/animate.css' );
  	wp_enqueue_style( 'vout-font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css' );
  	wp_enqueue_style( 'vout-font-awesome-min', CSS_PATH .'/font-awesome.min.css' );
	wp_enqueue_style( 'vout-owl-carousel', CSS_PATH . '/owl.carousel.min.css' );
  	wp_enqueue_style( 'vout-owl-theme-default', CSS_PATH . '/owl.theme.default.min.css' );
  	wp_enqueue_style( 'vout-style', CSS_PATH . '/style.css' );
  	wp_enqueue_style( 'vout-responsive', CSS_PATH . '/responsive.css' );
    
    wp_enqueue_style( 'gold-font-Poppins', 'https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700;800;900&display=swap' );
    wp_enqueue_style( 'gold-font-Cinzel', 'https://fonts.googleapis.com/css2?family=Cinzel:wght@400;500;600;700;800;900&display=swap' );

	wp_enqueue_script( 'hew_projects-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );
	
	wp_enqueue_script( 'vout-jquery', 'https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js', array('jquery'), '2.6.2', true );
	wp_enqueue_script( 'vout-jquery-migrate', js_path . '/jquery-migrate-1.2.1.js', array('jquery'), '2.6.2', true );
	wp_enqueue_script( 'vout-popper','https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js', array('jquery'), '2.6.2', true );
	wp_enqueue_script( 'vout-bootstrap', js_path . '/bootstrap.min.js', array('jquery'), '2.6.2', true );
//	wp_enqueue_script( 'vout-wow', js_path . '/wow.min.js', array('jquery'), '2.6.2', true );
	wp_enqueue_script( 'vout-isotope', js_path . '/isotope.pkgd.min.js', array('jquery'), '2.6.2', true );
	wp_enqueue_script( 'vout-owl-carousel', js_path . '/owl.carousel.min.js', array('jquery'), '2.6.2', true );
	wp_enqueue_script( 'vout-prettyPhoto', js_path . '/jquery.prettyPhoto.js', array('jquery'), '2.6.2', true );
	wp_enqueue_script( 'vout-themepunch-custom', js_path . '/jquery.themepunch.megafoliopro.min.js', array('jquery'), '2.6.2', true );
	wp_enqueue_script( 'vout-themepunch-min', js_path . '/jquery.themepunch.tools.min.js', array('jquery'), '2.6.2', true );
	wp_enqueue_script( 'vout-main-custom', js_path . '/main.js', array('jquery'), '2.6.2', true );


	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'z_build_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/**
 * Oursource Framework - Theme Functions
 */
require get_parent_theme_file_path( '/aussies_own/theme-functions.php' );

/**
 * Oursource Framework - NAV Walker
 */
require get_parent_theme_file_path( '/aussies_own/bootstrap-navwalker.php' );