<?php
/**
 * The front page template file
 *
 * If the user has selected a static page for their homepage, this is what will
 * appear.
 * Learn more: https://codex.wordpress.org/Template_Hierarchy
 *
 * @package altraspray

 */

get_header(); ?>
  
  <section class="about sec-padding">
    <div class="container">
         <?php
            // Check rows exists.
            if( have_rows('after_banner',27) ):
                $x=1;
                // Loop through rows.
                while( have_rows('after_banner',27) ) : the_row();
                    // Load sub field value.
                    $ab_title = get_sub_field('ab_title');
                    $ab_content = get_sub_field('content');
                    
                    ?>
        
        
                    <div class="about-content mb-4">
                        <div class="about-btn">
                          <span class="top-bar"></span>
                          <a href="#">Read More</a>
                          <span class="left-bar"></span>
                        </div>
                        <div class="row align-items-center">
                          <div class="col-md-4">
                              <?php echo $ab_title;?>
                          </div>
                          <div class="col-md-8">
                            <?php echo $ab_content;?>
                          </div>
                        </div>
                      </div>
         <?php $x++; endwhile;
            endif;
        ?>
    </div>
  </section>

  <section class="service sec-padding">
    <div class="container">
      <div class="section-header text-center">
        <h2>Our promise to you</h2>
      </div>
      <div class="service-content mt-5">
        <div class="row">
            <?php
            // Check rows exists.
            if( have_rows('our_promise_to_you',27) ):
                $x=1;
                // Loop through rows.
                while( have_rows('our_promise_to_you',27) ) : the_row();
                    // Load sub field value.
                    $abb_title = get_sub_field('abb_title');
                    $abb_content = get_sub_field('abb_content');
                    
                    ?>
            
                    <div class="col-md-4 d-flex">
                        <div class="service-shape">
                          <img src="<?php echo IMAGES_PATH; ?>/Shape1.png" alt="">
                        </div>
                        <div class="service-content-text">
                          <h3><?php echo $abb_title; ?></h3>
                          <p><?php echo $abb_content; ?></p>
                        </div>
                      </div>
                  <?php $x++; endwhile;
                    endif;
                ?>
          
        </div>
      </div>
    </div>
  </section>

  <section class="project sec-padding desktop">
    <div class="container">
      <div class="row align-items-center">
          <?php
           
                $k=1;
               $service_list = array( 'post_type' => array('service_list'), 'order_by' => 'id', 'order' => 'ASC', 'posts_per_page'   => -1 );
                      $posts_service_list =  get_posts( $service_list );
        
                foreach( $posts_service_list as $servicesnew_list)                      
                { 
        
                    $feat_image_service_list = wp_get_attachment_url( get_post_thumbnail_id($servicesnew_list->ID) ); 
                    $home_service_content = get_field('home_page_content',$servicesnew_list->ID);
                ?>
                <?php if($k%2==0){ ?>
                    <div class="col-md-7">
                      <div class="section-header">
                        <h2><?php  echo get_post_field('post_title',$servicesnew_list->ID); ?></h2>
                      </div>
                      <div class="project-content">
                        <p><?php  echo $home_service_content; ?></p>
                      </div>
                    </div>
                <?php } ?>
                    <div class="col-md-5">
                      <div class="img-box">
                        <div class="overlay"></div>
                        <div class="img-box-image">
                          <img src="<?php echo $feat_image_service_list;?>" alt="Service">
                        </div>
                        <div class="img-box-content">
                          <h3><?php  echo get_post_field('post_title',$servicesnew_list->ID); ?></h3>
                          <a href="<?php echo get_the_permalink($servicesnew_list->ID); ?>" class="p-button"><img src="<?php echo IMAGES_PATH; ?>/p-button.png" alt=""></a>
                        </div>
                      </div>
                    </div>
                    <?php if($k%2!=0){ ?>
                    <div class="col-md-7">
                      <div class="section-header">
                        <h2><?php  echo get_post_field('post_title',$servicesnew_list->ID); ?></h2>
                      </div>
                      <div class="project-content">
                        <p><?php  echo $home_service_content; ?></p>
                      </div>
                    </div>
                <?php } ?>
             <?php $k++; } ?>
      </div>
    </div>
  </section>


  <section class="project sec-padding mobile">
    <div class="container">
      <div class="row align-items-center">
          
       <?php
            // Check rows exists.
            if( have_rows('our_projects',27) ):
                //$k=1;
                // Loop through rows.
                while( have_rows('our_projects',27) ) : the_row();
                    // Load sub field value.
                    $gallery_title = get_sub_field('gallery_title');
                    $gallery_content = get_sub_field('gallery_content');
                    $gallery_image = get_sub_field('gallery_image');
                    ?>
                
                    <div class="col-md-7">
                      <div class="section-header">
                        <h2><?php echo $gallery_title;?></h2>
                      </div>
                      <div class="project-content">
                        <p><?php echo $gallery_content;?></p>
                      </div>
                    </div>
               
               
                    <div class="col-md-5">
                      <div class="img-box">
                        <div class="overlay"></div>
                        <div class="img-box-image">
                          <img src="<?php echo $gallery_image;?>" alt="">
                        </div>
                        <div class="img-box-content">
                          <h3><?php echo $gallery_title;?></h3>
                          <a href="#" class="p-button"><img src="<?php echo IMAGES_PATH; ?>/p-button.png" alt=""></a>
                        </div>
                      </div>
                    </div>
                   
             <?php //$k++;
             endwhile;
                    endif;
                ?>
      </div>
    </div>
  </section>


  <section class="cta sec-padding">
    <div class="container">
      <div class="cta-content text-center">
        <div class="section-header pb-4">
          <h2>Get in Touch With Us to know our new project</h2>
        </div>
        <div class="cta-btn">
          <span class="top-bar"></span>
          <a href="<?php echo get_the_permalink(37); ?>">Contact Us</a>
          <span class="left-bar"></span>
        </div>
      </div>
    </div>
  </section>


  <section class="project-galley sec-padding">
    <div class="container">
      <div class="project-galley-content text-center pb-4">
        <div class="section-header">
          <h2>Some Of Our Upcoming Projects</h2>
        </div>
      </div>
      <div id="project-galley-slider" class="owl-carousel owl-theme">
          
          <?php 
            $images = get_field('upcoming_project',27);
            if( $images ): 
            foreach( $images as $image ): ?>
          
             <div class="item">
              <div class="project-galley-box">
                <div class="image">
                  <img src="<?php echo esc_url($image['url']); ?>" alt="">
                </div>
              </div>
            </div>
         <?php endforeach; ?>
        <?php endif; ?>
      </div>
    </div>
  </section>


  <section class="wcu sec-padding">
    <div class="container">
      <div class="wcu-content">
        <div class="row">
          <div class="col-md-6">
            <div class="wcu-left-content">
              <?php echo get_field('why_choose_us',27);?>
              <div class="wcu-btn">
                <span class="top-bar"></span>
                <a href="<?php echo get_the_permalink(37); ?>">Contact Us</a>
                <span class="left-bar"></span>
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="wcu-right-content">
              <?php echo get_field('how_can_we_help_you',27);?><br><br>
              <?php echo get_field('work_together',27);?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>



  
<?php get_footer();
