<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package z-build
 */

?>

 <footer class="footer-main">
    <div class="container">
      <div class="footer-top sec-padding">
        <div class="row">
          <div class="col-md-4">
            <div class="footer-logo">
              <img src="<?php echo IMAGES_PATH; ?>/logo.png">
              <p>Z Design & Build is an Australian owned and operated company that has a vast wealth of experience in the design and construction industry. We are known for executing our work to perfection. With meticulous attention to detail and supreme workmanship, we deliver the best results every single time.</p>
              <div class="footer-social-icon">
                <a href=""><i class="fa fa-facebook" aria-hidden="true"></i></a>
                <a href=""><i class="fa fa-twitter" aria-hidden="true"></i></a>
                <a href=""><i class="fa fa-instagram" aria-hidden="true"></i></a>
              </div>
            </div>
          </div>
          <div class="col-md-3">
            <div class="footer-content">
              <h4>Services</h4>
              <?php
                $defaults = array(
                'theme_location'  => 'header menu',
                'menu'            => '3',
                'container'       => '',
                'container_class' => '',
                'container_id'    => '',
                'menu_class'      => 'footer-service',
                'menu_id'         => '',
                'echo'            => true,
                'fallback_cb'     => 'wp_page_menu',
                'before'          => '',
                'after'           => '',
                'link_before'     => '',
                'link_after'      => '',
                'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                'depth'           => 0,
              //  'walker'          => new bootstrap_navwalker()
                );
                wp_nav_menu($defaults);
             ?>
            </div>
          </div>
          <div class="col-md-2">
            <div class="footer-content">
              <h4>Menu</h4>
             <?php
                $defaults = array(
                'theme_location'  => 'header menu',
                'menu'            => '2',
                'container'       => '',
                'container_class' => '',
                'container_id'    => '',
                'menu_class'      => 'footer-service',
                'menu_id'         => '',
                'echo'            => true,
                'fallback_cb'     => 'wp_page_menu',
                'before'          => '',
                'after'           => '',
                'link_before'     => '',
                'link_after'      => '',
                'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                'depth'           => 0,
              //  'walker'          => new bootstrap_navwalker()
                );
                wp_nav_menu($defaults);
             ?>
            </div>
          </div>
          <div class="col-md-3">
              <div class="footer-content">
              <h4>Contact</h4>
           <ul class="footer-location">
              <li>
                <i class="fa fa-map-marker" aria-hidden="true"></i>
                Railway Terrace Merrylands NSW 2160
              </li>
              <li>
                <i class="fa fa-phone" aria-hidden="true"></i>
                <a class="footer-mobile"  href="tel:0402 884 714"> 0402 884 714</a>
              </li>
              <li>
                <i class="fa fa-envelope" aria-hidden="true"></i>
                <a href="mailto:info@zdesign.com.au">
                  info@zdesign.com.au
                </a>
              </li>
            </ul>
            </div>
            
          </div>
     
        </div>
      </div>
    </div>
    <div class="footer-bottom bg-dark text-center pb-3 pt-3">
      <p class="text-white mb-0">Copyright © <?php echo date('Y'); ?>. All Rights Reserved. Designed By Aussies Own</p>
    </div>
  </footer>


  <div class="sticky">
    <div class="sticky-button">
      <a href="#" data-toggle="modal" data-target="#exampleModal"><img src="<?php echo IMAGES_PATH; ?>/banner-btn.png"></a>
    </div>
    <div class="sticky-button2">
      <a href="tel:0421 777 888"><img src="<?php echo IMAGES_PATH; ?>/banner-btn2.png"></a>
    </div>
  </div>
  
  <!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Get A Quote</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
      <?php echo do_shortcode('[contact-form-7 id="110" title="Contact Us"]');?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        
      </div>
    </div>
  </div>
</div>

<?php wp_footer(); ?>

</body>
</html>
