<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package M_&_K_Mechanic
 */

get_header();
?>

  <section class="main-wrap">

  	<div class="container">

    	<h2 class="main-title">Articles of Interest</h2>

        <div class="row mar-top">
        <?php                
            while(have_posts()) {  the_post();
             $feat_image_blog_post = wp_get_attachment_url( get_post_thumbnail_id() ); 
        ?>

            <div class="col-sm-4">

            	<div class="article-box">

                	<div class="article-img">

                    	<?php if(has_post_thumbnail()) {?>
				           <img class="img-responsive" src="<?php echo $feat_image_blog_post; ?>">
				        <?php } else { ?>
				           <img class="img-responsive" src="<?php echo IMAGE_PATH; ?>images/No_image_available.png">
                        <?php } ?>

                        <h4><?php echo get_the_date('M j, Y') ?></h4>

                    </div>

                    <div class="article-txt">

                    	<h4><?php the_title(); ?></h4>

                        <p><?php echo wp_trim_words(get_the_content(),'25','...'); ?></p>

                        <a href="<?php echo esc_url(get_permalink());?>">View All</a>

                    </div>

                </div>

            </div>
            <?php }  ?>




        </div>

    </div>

  </section>

<?php
get_footer();
