<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package M_&_K_Mechanic
 */
global $vtd_option;
?>

<!DOCTYPE html>

<html lang="en">

  <head>

    <meta charset="utf-8">

    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php wp_head(); ?>

  </head>

  <body>

  

  <header class="header">

  	<div class="container">

    	<div class="row">

        	<div class="col-sm-2">

            	<div class="logo">

                	<a href="<?php echo site_url(); ?>"><img class="img-responsive" src="<?php echo $vtd_option['logo']['url'] ?>" alt="" /></a>

                </div>

            </div>

            <div class="col-sm-10">

            	<div class="menu">

                    <nav class="navbar navbar-default"> 

                    <!-- Brand and toggle get grouped for better mobile display -->

                    <div class="navbar-header">

                      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1"> <span class="sr-only">Toggle navigation</span> <span class="icon-bar"></span> <span class="icon-bar"></span> <span class="icon-bar"></span> </button>

                    </div>

                    

                    <!-- Collect the nav links, forms, and other content for toggling -->

                    <?php   $menu = array(
            			                'menu'            => 'Menu',
            			                'menu_id'         => '2',
            			                'menu_class'      => 'nav navbar-nav',
            			                'container_class' => 'collapse navbar-collapse',
            			                'container_id'    => 'bs-example-navbar-collapse-1',
                                        'walker'          => new wp_bootstrap_navwalker()
			                      ) ;
			                    wp_nav_menu($menu);
			        ?>

                    <!-- /.navbar-collapse --> 

                  </nav>

                </div>

            </div>

        </div>

    </div>

  </header>

  
<?php if(is_front_page()){ ?>

  <div class="banner">

  	<img class="img-responsive" src="<?php echo $vtd_option['banner_bg']['url'] ?>" alt="" />

    <div class="banner-txt">

    	<div class="container">

        	<?php echo $vtd_option['banner_con'] ?>

        </div>

    </div>

    <div class="car-img">

    	<img class="img-responsive" src="<?php echo $vtd_option['banner_img']['url'] ?>" alt="" />

    </div>

<?php } else{ ?>

  <div class="banner">

  	<img class="img-responsive" src="<?php echo $vtd_option['inner_banner']['url'] ?>" alt="" />

 <?php } ?>

    <a href="#" class="btn-enquiry" data-toggle="modal" data-target="#quote">Make an &nbsp; Enquiry</a>

  </div>
